package com.ejie.ab04b.control;

import com.ejie.ab04b.service.ClaseCentroTrabajoService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.ClaseCentroTrabajo;

/**
 * ClaseCentroTrabajoController generated by UDA, 22-feb-2017 17:06:37.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/claseCentroTrabajo")

public class ClaseCentroTrabajoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ClaseCentroTrabajoController.class);

	@Autowired()
	private ClaseCentroTrabajoService claseCentroTrabajoService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  clasctr072
	 *            String
	 *
	 * @param clasctr072 the clasctr 072
	 *  ClaseCentroTrabajo Objeto correspondiente al identificador
	 *         indicado.
	 * @return the clase centro trabajo
	 */
	@RequestMapping(value = "/{clasctr072}", method = RequestMethod.GET)
	public @ResponseBody ClaseCentroTrabajo get(
			@PathVariable String clasctr072) {
		ClaseCentroTrabajo claseCentroTrabajo = new ClaseCentroTrabajo();
		claseCentroTrabajo.setClasctr072(clasctr072);
		claseCentroTrabajo = this.claseCentroTrabajoService
				.find(claseCentroTrabajo);
		ClaseCentroTrabajoController.logger
				.info("[GET - findBy_PK] : Obtener ClaseCentroTrabajo por PK");
		return claseCentroTrabajo;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterClaseCentroTrabajo
	 *            ClaseCentroTrabajo Objeto que contiene los parametros de
	 *            filtrado utilizados en la busqueda.
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 *  List<ClaseCentroTrabajo> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<ClaseCentroTrabajo> getAll(
			@ModelAttribute ClaseCentroTrabajo filterClaseCentroTrabajo) {
		ClaseCentroTrabajoController.logger.info(
				"[GET - find_ALL] : Obtener ClaseCentroTrabajo por filtro");
		return this.claseCentroTrabajoService.findAll(filterClaseCentroTrabajo,
				null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo Bean que contiene la informacion a
	 *            modificar.
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 *  ClaseCentroTrabajo Bean resultante de la modificacion.
	 * @return the clase centro trabajo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody ClaseCentroTrabajo edit(
			@RequestBody ClaseCentroTrabajo claseCentroTrabajo) {
		ClaseCentroTrabajo claseCentroTrabajoAux = this.claseCentroTrabajoService
				.update(claseCentroTrabajo);
		ClaseCentroTrabajoController.logger
				.info("[PUT] : ClaseCentroTrabajo actualizado correctamente");
		return claseCentroTrabajoAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo Bean que contiene la informacion con la que
	 *            se va a crear el nuevo registro.
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 *  ClaseCentroTrabajo Bean resultante del proceso de creacion.
	 * @return the clase centro trabajo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody ClaseCentroTrabajo add(
			@RequestBody ClaseCentroTrabajo claseCentroTrabajo) {
		ClaseCentroTrabajo claseCentroTrabajoAux = this.claseCentroTrabajoService
				.add(claseCentroTrabajo);
		ClaseCentroTrabajoController.logger
				.info("[POST] : ClaseCentroTrabajo insertado correctamente");
		return claseCentroTrabajoAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  clasctr072
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param clasctr072 the clasctr 072
	 *  ClaseCentroTrabajo Bean eliminado.
	 * @return the clase centro trabajo
	 */
	@RequestMapping(value = "/{clasctr072}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody ClaseCentroTrabajo remove(
			@PathVariable String clasctr072) {
		ClaseCentroTrabajo claseCentroTrabajo = new ClaseCentroTrabajo();
		claseCentroTrabajo.setClasctr072(clasctr072);
		this.claseCentroTrabajoService.remove(claseCentroTrabajo);
		ClaseCentroTrabajoController.logger
				.info("[DELETE] : ClaseCentroTrabajo borrado correctamente");
		return claseCentroTrabajo;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ClaseCentroTrabajoController.logger
				.info("[GET - View] : clasecentrotrabajo");
		return "clasecentrotrabajo";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterClaseCentroTrabajo
	 *            ClaseCentroTrabajo Bean que contiene los parametros de
	 *            filtrado a emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<ClaseCentroTrabajo> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<ClaseCentroTrabajo> filter(
			@RequestJsonBody(param = "filter") ClaseCentroTrabajo filterClaseCentroTrabajo,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ClaseCentroTrabajoController.logger
				.info("[POST - filter] : Obtener ClaseCentroTrabajos");
		return this.claseCentroTrabajoService.filter(filterClaseCentroTrabajo,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterClaseCentroTrabajo
	 *            ClaseCentroTrabajo Bean que contiene los parametros de
	 *            filtrado a emplear.
	 *  searchClaseCentroTrabajo
	 *            ClaseCentroTrabajo Bean que contiene los parametros de
	 *            busqueda a emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param searchClaseCentroTrabajo the search clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<ClaseCentroTrabajo> Dto que contiene el resultado de
	 *         la busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<ClaseCentroTrabajo>> search(
			@RequestJsonBody(param = "filter") ClaseCentroTrabajo filterClaseCentroTrabajo,
			@RequestJsonBody(param = "search") ClaseCentroTrabajo searchClaseCentroTrabajo,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ClaseCentroTrabajoController.logger
				.info("[POST - search] : Buscar ClaseCentroTrabajos");
		return this.claseCentroTrabajoService.search(filterClaseCentroTrabajo,
				searchClaseCentroTrabajo, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterClaseCentroTrabajo            ClaseCentroTrabajo Bean que contiene los parametros de
	 *            filtrado a emplear.
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") ClaseCentroTrabajo filterClaseCentroTrabajo,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ClaseCentroTrabajoController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples ClaseCentroTrabajos");
		this.claseCentroTrabajoService.removeMultiple(filterClaseCentroTrabajo,
				jqGridRequestDto, false);
		ClaseCentroTrabajoController.logger
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterClaseCentroTrabajo            Expediente Bean que contiene los parÃ¡metros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap            ModelMap
	 *  columns            String
	 *  request            HttpServletRequest
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() ClaseCentroTrabajo filterClaseCentroTrabajo,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<ClaseCentroTrabajo> listClaseCentroTrabajo = this.claseCentroTrabajoService
				.findAllLike(filterClaseCentroTrabajo, jqGridRequestDto, false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.clasesCentrosTrabajo"),
				columns, listClaseCentroTrabajo);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}

}
